# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 13:11:55 2015


"""

import numpy as np
import pickle
import os.path

# Import data from file
data = np.genfromtxt('c:\\temp\\Rutherford_data.csv',delimiter=',')


rivers = data[:,0]

# hard coded inputs for now
g = 9.81
river_length = 100 #in meters

# Pollutant inputs in kg
mass = 5.0

# Spatial parameters
x_step = 1.0
y_step = 1.0

# Pollution parameters (pollutant mass in kg)
mass = 5.0 

# Mixing parameters
dispersion_elder_x = 5.93
dispersion_elder_y = 0.15

class CInputModule:
    
    def __init__(self):
        self = self
        
    def LoadDataInputs(self,ARiverIndex):
        self.Analysis.River.Name = data[ARiverIndex,0]
        self.Analysis.River.Depth = data[ARiverIndex,1]
        self.Analysis.River.Width = data[ARiverIndex,2]
        self.Analysis.River.MeanVelocity = data[ARiverIndex,3]
        self.Analysis.River.Slope = data[ARiverIndex,4]
        
        self.LoadOtherRiver()
        self.LoadPollutant()
        self.LoadSpatialParameters()        
        self.LoadMixingParameters()
        

    def LoadMixingParameters(self):
        self.Analysis.MixingParameters.DispersionElderX = dispersion_elder_x
        self.Analysis.MixingParameters.DispersionElderY = dispersion_elder_y
            
    def LoadObject(self,AFilepath):
        if not (os.path.exists(AFilepath)):
            print ("Filepath %s does not exist" % AFilepath)
            return []
        with open(AFilepath, 'rb') as input:
            return pickle.load(input)
    
    def LoadOtherRiver(self):
        self.Analysis.River.Gravity = g        
        self.Analysis.River.Length = river_length
        
    def LoadPollutant(self):
        self.Analysis.Pollutant.Mass = mass

    def LoadSpatialParameters(self):
        self.Analysis.SpatialParameters.XStep = x_step
        self.Analysis.SpatialParameters.YStep = y_step

    def SetAnalysis(self, AAnalysis):
        self.Analysis = AAnalysis
    
    def NumberOfRivers(self):    
        return len(rivers)
